#!/bin/sh

# MCCreateSSLCertificate.sh
# MCClientServer
#
# Created by Brent Gulanowski on 11/02/09.
# Copyright 2009 Marketcircle, Inc. All rights reserved.


if [ ! -e ./openssl.cfg ]
then
	exit 1
fi

# Do this so key creation can write a .rnd (pseudo-random data)
HOME=.
export HOME

rm *.pem 2>/dev/null
rm *.p12 2>/dev/null

umask 0077

openssl req -config ./openssl.cfg -new -keyout "server-certkey.pem" -out "server-certreq.pem"
if [ 0 -ne $? ]; then exit $?; fi

openssl req -config ./openssl.cfg -x509 -days 3650 -in "server-certreq.pem" -text -key "server-certkey.pem" -out "server-cert.pem"
if [ 0 -ne $? ]; then exit $?; fi

#openssl pkcs12 -export -passout pass:"password" -inkey "server-certkey.pem" -in "server-cert.pem" -out "server.p12"
#if [ 0 -ne $? ]; then exit $?; fi
